﻿//=============================================================================
// USB IO Board Controller v2.0
// Copyright www.Electronics-DIY.com © 2002-2012. All Rights Reserved. 
// THIS SOURCECODE CAN ONLY BE USED FOR PERSONAL USE
// DO NOT REPRODUCE WITHOUT PERMISSION
//=============================================================================
// Compiled with free Visual C# 2008 Express Edition 
// http://www.microsoft.com/visualstudio/en-us/products/2008-editions/express
//=============================================================================

using System;
using System.Windows.Forms;
using System.IO.Ports;

namespace USB_IO_Board_Controller
{
    public partial class Form1 : Form
    {
        public SerialPort Port = new SerialPort("COM1", 57600, Parity.None, 8, StopBits.One);

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            ListCOMPorts();
        }

        //List COM Ports
        private void ListCOMPorts()
        {
            foreach (string s in SerialPort.GetPortNames())
            {
                cboCOMPorts.Items.Add(s);
            } 
	        cboCOMPorts.Sorted = true;
        }

        //Connect to COM Port
        private void cboCOMPorts_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                Port.PortName = cboCOMPorts.Text;

                if (!Port.IsOpen)
                {
                    StatusBar.Text = "Connected to " + Port.PortName;
                    Port.Open();
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        //Send Command to USB IO Board
        private void btnSend_Click(object sender, EventArgs e)
        {
            if (Port.IsOpen)
            {
                //Port.Write("C,0,0,0,0" + '\r') 'Example: Configure all ports as outputs
                Port.Write(cboCommandInput.Text + '\r');
                System.Threading.Thread.Sleep(100); //ms
                ReceiveData();
            }
            else
            {
                StatusBar.Text = "Select COM port";
            }
        }

        //Receive Data from USB IO Board
        private void ReceiveData()
        {
            string output = null;
            byte[] Buffer = new byte[Port.BytesToRead];

            Port.Read(Buffer, 0, Port.BytesToRead);

            for (int i = 0; i <= Buffer.Length - 1; i++)
            {
                output += Microsoft.VisualBasic.Strings.Chr(Buffer[i]);
            }
            txtOutput.Text = output  + txtOutput.Text;
        }
    }
}
